;*****************************************************************************************************************************************
;Source File Name:
;		magic.jss
;Author's Name:
;		Ben Key 
;Description:
;		JFW script file used to encapsulate MAGic tracking related scripts and functions that need
;		to be loaded with the default script set into their own file.  This was done to aid in keeping
; 		MAGic and JFW scripts seperat from each other and to improve the maintainability of the MAGic
; 		tracking project.
;Included Header Files:
;		hjconst.jsh			default HJ constants 
;		hjglobal.jsh		default HJ global variables
;		default.jsm			included for default MAGic messages
;		magCodes.jsh	constants for MAGic commands and key events
; 		magic.jsh			Constants and globals used by the magic tracking functions
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;						                          MODIFICATION LOG
;
;Date					Author						Description
;----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************

Include "hjglobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
Include "default.jsm"
Include "magCodes.jsh"
Include "magic.jsh"

;*****************************************************************************************************************************************
;Script:	
;		NextCharacter ()
;Author's Name:
;		Ben Key
;Description:
;		This script is listed in the default.jkm file that is found in the hjtrack project.  It is only called
; 		when MAGic is running using the hjtrack tracking engine.  It is designed to eliminate the speech
; 		specific processing that takes place in the default SayNextCharacter () script.  Its only functions are
; 		to call the built in function NextCharacter and to call TrackStartMenu (...)
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script NextCharacter ()
NextCharacter ()
;If we are in the start menu, then we'll want to track it.  This function does nothing and returns FALSE if the startmenu
;is not active.
TrackStartMenu(GetCurrentWindow())
EndScript

;*****************************************************************************************************************************************
;Script:	
;		PriorCharacter ()
;Author's Name:
;		Ben Key
;Description:
;		This script is listed in the default.jkm file that is found in the hjtrack project.  It is only called
; 		when MAGic is running using the hjtrack tracking engine.  It is designed to eliminate the speech
; 		specific processing that takes place in the default SayPriorCharacter () script.  Its only functions are
; 		to call the built in function PriorCharacter and to call TrackStartMenu (...)
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script PriorCharacter ()
PriorCharacter ()
;If we are in the start menu, then we'll want to track it.  This function does nothing and returns FALSE if the startmenu
;is not active.
TrackStartMenu(GetCurrentWindow())
EndScript

;*****************************************************************************************************************************************
;Script:	
;		NextLine ()
;Author's Name:
;		Ben Key
;Description:
;		This script is listed in the default.jkm file that is found in the hjtrack project.  It is only called
; 		when MAGic is running using the hjtrack tracking engine.  It is designed to eliminate the speech
; 		specific processing that takes place in the default SayNextLine () script.  Its only function is
; 		to call the built in function NextLine.
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script NextLine ()
NextLine ()
EndScript

;*****************************************************************************************************************************************
;Script:	
;		PriorLine ()
;Author's Name:
;		Ben Key
;Description:
;		This script is listed in the default.jkm file that is found in the hjtrack project.  It is only called
; 		when MAGic is running using the hjtrack tracking engine.  It is designed to eliminate the speech
; 		specific processing that takes place in the default SayNextLine () script.  Its only function is
; 		to call the built in function PriorLine ().
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script PriorLine ()
PriorLine ()
EndScript

;*****************************************************************************************************************************************
;Script:	
;		NextWord ()
;Author's Name:
;		Ben Key
;Description:
;		This script is listed in the default.jkm file that is found in the hjtrack project.  It is only called
; 		when MAGic is running using the hjtrack tracking engine.  It is designed to eliminate the speech
; 		specific processing that takes place in the default SayNextWord () script.  Its only function is
; 		to call the built in function NextWord ().
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script NextWord ()
NextWord ()
EndScript

;*****************************************************************************************************************************************
;Script:	
;		PriorWord ()
;Author's Name:
;		Ben Key
;Description:
;		This script is listed in the default.jkm file that is found in the hjtrack project.  It is only called
; 		when MAGic is running using the hjtrack tracking engine.  It is designed to eliminate the speech
; 		specific processing that takes place in the default SayPriorWord () script.  Its only function is
; 		to call the built in function PriorWord ().
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script PriorWord ()
PriorWord ()
EndScript

;*****************************************************************************************************************************************
;Script:	
;		ReportMagState ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to report the current state of MAGic.  If MAGic is not running or MAGic is running and 
;  	the screen is not magnified JFW will report "MAGic is not active."  If MAGic is running and the screen is 
;		magnified, JFW will report that MAGic is active and give the current level of magnification.
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script ReportMagState ()
If (MagGetState () > 0) then Say (mag001 + mag002 + IntToString (MagGetOption (MID_LEVEL)), ot_message) Else Say (mag004, ot_message) EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagSetTrackAlignment ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to display a list box of the possible settings for MAGic tracking alignment and to 
;		allow the user to set the current track alignment settings.  Tracking alignment can be set to 
;		TRACK_ALIGNMENT_EDGE, TRACK_ALIGNMENT_CENTER, TRACK_ALIGNMENT_CONTINUOUS, or 
;		TRACK_ALIGNMENT_PREDICTIVE.
;		This script first calls the function DlgSelectItemInList (...) with the string "edge|center|continuous|predictive"
;		as its first parameter.  Then the user selects an item from the list and DlgSelectItemInList (...) returns a 
;		integer value indicating which item was selected (Edge = 1, Center = 2, ...).  If the user did not press the cancel 
;		button or the escape key (in which case DlgSelectItemInList (...) returns 0), the built in function 
;		MagSetTrackAlignment (...) is called with the parameter nAlignment - 1 (this is necesary because the built in 
; 		values for the alignment settings are 0 based and not 1 based).  Then the new alignment setting is spoken by JFW.
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagSetTrackAlignment ()
;mag009 = "edge|center|continuous|predictive",
;mag010 = "Tracking Alignment",
;mag011 = "Tracking Alignment set to "
var int nAlignment, string strSetTo
let nAlignment = DlgSelectItemInList (mag009, mag010, FALSE)
if (nAlignment >= 0) then
	MagSetTrackAlignment (nAlignment - 1)
	let strSetTo = mag011
	let strSetTo = strSetTo + StringSegment (mag009, "|", nAlignment)
	Say (strSetTo, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		CenterMouseInView ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to allow the user to easily center the mouse in the active view.   If MAGic is running 
;		and the screen is magnified, then the mouse is centered in the active view.  Otherwise, the mouse is 
; 		positioned in the center of the display.
;		This script works by calling the built in function CenterMouseInView ().  Then the message "Mouse Centered" is 
;		spoken by JFW.
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script CenterMouseInView ()
;mag012 = "Mouse Centered"
CenterMouseInView ()
Say (mag012, OT_STATUS)
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagCustomColorsToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle the color button on the MAGic user interface.  When this is done, the color
;		options that were previously set are restored.  This script does not modify those settings.  It only turns the set
;		color options on or off.
;		This script first calls the built in function MagGetOption (COL_CUSTOM) to get the current custom color settings.
;		Then it calls the function MagSendKeyEvent (KI_CUSTOM_COLORS_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_CUSTOM_COLORS_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, if the custom colors were previously on, JFW reports "Custom Colors Off" and if they were previously
;		off JFW reports "Custom Colors On."
;		** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagCustomColorsToggle ()
;mag013 = "Custom Colors On"
;mag014 = "Custom Colors Off"
;mag017 = "MAGic Not running"
var int bOn
let bOn = MagGetOption(COL_CUSTOM)
if (MagSendKeyEvent (KI_CUSTOM_COLORS_TOGGLE)) then
	if (bOn) then
		Say(mag014, OT_STATUS)
	else
		Say(mag013, OT_STATUS)
	endif
else
	Say (mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagCustomMouseToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle the mouse button on the MAGic user interface.  When this is done, the custom 
;		mouse options that were previously set are restored.  This script does not modify those settings.  It only turns the 
;		set	custom mouse options on or off.
;		This script first calls the built in function MagGetOption (MOUSE_BTN) to get the current custom mouse settings.
;		Then it calls the function MagSendKeyEvent (KI_CUSTOM_MOUSE_TOGGLE) to toggle the current setting.
;		If (MagSendKeyEvent (KI_CUSTOM_MOUSE_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, if the custom mouse was previously on, JFW reports "Custom Mouse Off" and if it was previously
;		off JFW reports "Custom Mouse On."
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagCustomMouseToggle ()
;mag015 = "Custom Mouse On",
;mag016 = "Custom Mouse Off",
;mag017 = "MAGic Not running"
var int bOn
let bOn = MagGetOption(MOUSE_BTN)
if (MagSendKeyEvent (KI_CUSTOM_MOUSE_TOGGLE)) then
	if (bOn) then
		Say(mag016, OT_STATUS)
	else
		Say(mag015, OT_STATUS)
	endif
else
	Say (mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagShiftViewToMouse ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to shift the magnified view in order to bring the mouse into view when the screen is 
;		magnified.  This is done by calling the function MagSendKeyEvent (KI_SHIFT_VIEW_TO_MOUSE).  Then 
;		JFW speaks the message "Shift View To Mouse."
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagShiftViewToMouse ()
;mag018 = "Shift View To Mouse",
;mag023 = "screen not magnified"
if (MagGetState() > 1) then
	if (MagSendKeyEvent (KI_SHIFT_VIEW_TO_MOUSE)) then
		Say (mag018, OT_MESSAGE)
	endif
else
	Say(mag023, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagInverseMagnifiedMouse ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to Inverse the color of the Mouse in the MAGic view.
;		This script first calls the built in function MagGetOption (M1_INVERSE) to determine if the MAGic View mouse 
;		is currently inverted.  Then it calls the function MagSendKeyEvent (KI_INVERSE_MAGNIFIED_MOUSE_TOGGLE) 
;		to toggle the current setting.  If (MagSendKeyEvent (KI_INVERSE_MAGNIFIED_MOUSE_TOGGLE) returned 0, 
;		JFW reports "MAGic Not running."   	Otherwise, if the Magic View mouse was previously inverted, JFW reports
;		magic view mouse not inverted" and if it was not previously inverted JFW reports "magic view mouse inverted."
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagInverseMagnifiedMouse ()
;mag019 = "magic view mouse Inverted",
;mag020 = "magic view mouse not inverted
var int nOn
let nOn = MagGetOption (M1_INVERSE )
if (MagSendKeyEvent (KI_INVERSE_MAGNIFIED_MOUSE_TOGGLE)) then
	if (nOn) then
		Say(mag020, OT_STATUS)
	else
		Say(mag019, OT_STATUS)
	endif
else
	Say(mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagInverseUnmaginfiedMouse ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to Inverse the color of the Mouse in the real view.
;		This script first calls the built in function MagGetOption (M0_INVERSE) to determine if the real view mouse 
;		is currently inverted.  Then it calls the function MagSendKeyEvent (KI_INVERSE_UNMAGNIFIED_MOUSE_TOGGLE) 
;		to toggle the current setting.  If (MagSendKeyEvent (KI_INVERSE_UNMAGNIFIED_MOUSE_TOGGLE) returned 0, 
;		JFW reports "MAGic Not running."   	Otherwise, if the real view mouse was previously inverted, JFW reports
;		real view mouse not inverted" and if it was not previously inverted JFW reports "real view mouse inverted."
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagInverseUnmaginfiedMouse ()
;mag021 = "real view mouse inverted",
;mag022 = "real view mouse not inverted"
var int nOn
let nOn = MagGetOption (M0_INVERSE )
if (MagSendKeyEvent (KI_INVERSE_UNMAGNIFIED_MOUSE_TOGGLE)) then
	if (nOn) then
		Say(mag022, OT_STATUS)
	else
		Say(mag021, OT_STATUS)
	endif
else
	Say(mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagDecrementMagnificationLevel ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to decrease the level of magnification by one.
;		This script first calls the built in function MagGetOption (MID_LEVEL) to determine the current level of 
;		magnification.  Then determines if the current level is greater than 1.  If the current level of magnification is
;		not greater than 1, the function Beep () is called to cause a beep through the PC Speaker.  If the current level
;		of magnification is greater than 1, the script calls the function MagSendKeyEvent (KI_DECREASE_MAG_LEVEL) 
;		to decrease the level by one.  If (MagSendKeyEvent (KI_DECREASE_MAG_LEVEL) returned 0, 
;		JFW reports "MAGic Not running."   	Otherwise, reports the current level of magnification.
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagDecrementMagnificationLevel ()
var int nLevel
let nLevel = MagGetOption (MID_LEVEL)
if (nLevel == 1) then
	Beep()
	Return
endif
if (MagSendKeyEvent (KI_DECREASE_MAG_LEVEL)) then
	Say(IntToString (nLevel-1), OT_STATUS)
else
	Say(mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagIncrementMagnificationLevel ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to increase the level of magnification by one.
;		This script first calls the built in function MagGetOption (MID_LEVEL) to determine the current level of 
;		magnification.  Then determines if the current level is less than 20.  If the current level of magnification is
;		not less than 20, the function Beep () is called to cause a beep through the PC Speaker and the script returns.  
;		If the current level	of magnification is less than 20, the script calls the function MagSendKeyEvent (KI_INCREASE_MAG_LEVEL) 
;		to increase the level by one.  If (MagSendKeyEvent (KI_INCREASE_MAG_LEVEL) returned 0, 
;		JFW reports "MAGic Not running."   	Otherwise, reports the current level of magnification.
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagIncrementMagnificationLevel ()
var int nLevel
let nLevel = MagGetOption (MID_LEVEL)
if (nLevel == 20) then
	Beep()
	Return
endif
if (MagSendKeyEvent (KI_INCREASE_MAG_LEVEL)) then
	Say(IntToString (nLevel+1), OT_STATUS)
else
	Say(mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagIncreaseMAGicMouseLevel ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to increase the magnification factor of the MAGic view mouse by one.
;		This script first calls the built in function MagGetOption (M1_FACTOR) to determine the current 
;		magnification factor of the MAGic view mouse.  Then determines if the current magnification factor 
;		is less than 10.  If the current magnification factor is not less than 10, the function Beep () is called to 
;		cause a beep through the PC Speaker and the script returns.  If the current magnification factor is less 
;		than 10, the script calls the function MagSendKeyEvent (KI_INCREASE_MAGNIFIED_MOUSE_LEVEL) 
;		to increase the level by one.  If (MagSendKeyEvent (KI_INCREASE_MAGNIFIED_MOUSE_LEVEL) returned 0, 
;		JFW reports "MAGic Not running."   	Otherwise, reports the current magnification factor of the MAGic view mouse.
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagIncreaseMAGicMouseLevel ()
var int nLevel
let nLevel = MagGetOption (M1_FACTOR )
if (nLevel == 10) then
	Beep()
	Return
endif
if (MagSendKeyEvent (KI_INCREASE_MAGNIFIED_MOUSE_LEVEL)) then
	Say(IntToString (nLevel+1), OT_STATUS)
else
	Say(mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagDecreaseMAGicMouseLevel ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to decrease the magnification factor of the MAGic view mouse by one.
;		This script first calls the built in function MagGetOption (M1_FACTOR) to determine the current 
;		magnification factor of the MAGic view mouse.  Then determines if the current magnification factor 
;		is greater than 1.  If the current magnification factor is not greater than 1, the function Beep () is called to 
;		cause a beep through the PC Speaker and the script returns.  If the current magnification factor is greater 
;		than 1, the script calls the function MagSendKeyEvent (KI_DECREASE_MAGNIFIED_MOUSE_LEVEL) 
;		to increase the level by one.  If (MagSendKeyEvent (KI_DECREASE_MAGNIFIED_MOUSE_LEVEL) returned 0, 
;		JFW reports "MAGic Not running."   	Otherwise, reports the current magnification factor of the MAGic view mouse.
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagDecreaseMAGicMouseLevel ()
var int nLevel
let nLevel = MagGetOption (M1_FACTOR )
if (nLevel == 1) then
	Beep()
	Return
endif
if (MagSendKeyEvent (KI_DECREASE_MAGNIFIED_MOUSE_LEVEL)) then
	Say(IntToString (nLevel-1), OT_STATUS)
else
	Say(mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagIncreaseRealMouseLevel ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to increase the magnification factor of the real view mouse by one.
;		This script first calls the built in function MagGetOption (M0_FACTOR) to determine the current 
;		magnification factor of the real view mouse.  Then determines if the current magnification factor 
;		is less than 10.  If the current magnification factor is not less than 10, the function Beep () is called to 
;		cause a beep through the PC Speaker and the script returns.  If the current magnification factor is less 
;		than 10, the script calls the function MagSendKeyEvent (KI_INCREASE_UNMAGNIFIED_MOUSE_LEVEL) 
;		to increase the level by one.  If MagSendKeyEvent (KI_INCREASE_UNMAGNIFIED_MOUSE_LEVEL) returned 0, 
;		JFW reports "MAGic Not running."   	Otherwise, reports the current magnification factor of the real view mouse.
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagIncreaseRealMouseLevel ()
var int nLevel
let nLevel = MagGetOption (M0_FACTOR )
if (nLevel == 10) then
	Beep()
	Return
endif
if (MagSendKeyEvent (KI_INCREASE_UNMAGNIFIED_MOUSE_LEVEL)) then
	Say(IntToString (nLevel+1), OT_STATUS)
else
	Say(mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagDecreaseRealMouseLevel ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to decrease the magnification factor of the real view mouse by one.
;		This script first calls the built in function MagGetOption (M0_FACTOR) to determine the current 
;		magnification factor of the real view mouse.  Then determines if the current magnification factor 
;		is greater than 1.  If the current magnification factor is not greater than 1, the function Beep () is called to 
;		cause a beep through the PC Speaker and the script returns.  If the current magnification factor is greater 
;		than 1, the script calls the function MagSendKeyEvent (KI_DECREASE_UNMAGNIFIED_MOUSE_LEVEL) 
;		to increase the level by one.  If MagSendKeyEvent (KI_DECREASE_UNMAGNIFIED_MOUSE_LEVEL) returned 0, 
;		JFW reports "MAGic Not running."   	Otherwise, reports the current magnification factor of the real view mouse.
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagDecreaseRealMouseLevel ()
var int nLevel
let nLevel = MagGetOption (M0_FACTOR )
if (nLevel == 1) then
	Beep()
	Return
endif
if (MagSendKeyEvent (KI_DECREASE_UNMAGNIFIED_MOUSE_LEVEL)) then
	Say(IntToString (nLevel-1), OT_STATUS)
else
	Say(mag017, OT_STATUS)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagLocatorsToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle locators on and off.
;		This script first calls the function MagGetOption (LOC_ON) to determine the current locators status.
;		Then it calls the function MagSendKeyEvent (KI_LOCATORS_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_LOCATORS_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, if locators were previously on, JFW reports "Locators Off" and if they was previously
;		off JFW reports "Locators On."
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagLocatorsToggle ()
var int nOn
let nOn = MagGetOption (LOC_ON)
if (MagSendKeyEvent (KI_LOCATORS_TOGGLE)) then
	if (nOn) then
		Say(mag025, OT_STATUS)
	else
		Say(mag024, OT_STATUS)
	endif
else
	Say(mag017, OT_MESSAGE)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MAGicWindow ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to activate the MAGic UI.
;		This script calls the function MagSendKeyEvent (KI_POP_MAGIC_WINDOW) to bring the MAGic window into 
;		focus.  If this function returns 0, JFW reports that MAGic is not running.
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MAGicWindow ()
if (!MagSendKeyEvent (KI_POP_MAGIC_WINDOW)) then
	Say(mag017, OT_MESSAGE)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagnificationToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle magnification on and off.
;		This script first calls the function MagGetOption (MID_ON) to determine the current magnification status.
;		Then it calls the function MagSendKeyEvent (KI_MAGNIFY_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_MAGNIFY_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, if magnification was previously on, JFW reports "Magnification Off" and if it was previously
;		off JFW reports "Magnification On" and then the script calles MagGetOption (MID_LEVEL) to get the current 
;		level of magnification and speaks it.
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagnificationToggle ()
var int nOn
let nOn = MagGetOption (MID_ON)
if (MagSendKeyEvent (KI_MAGNIFY_TOGGLE)) then
	if (nOn) then
		Say(mag027, OT_STATUS)
	else
		Say(mag026, OT_STATUS)
		Say(IntToString (MagGetOption(MID_LEVEL)), OT_STATUS)
	endif
else
	Say(mag017, OT_MESSAGE)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagFullScreen ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to activate full screen area mode.
;		This function first calls the function MagSendKeyEvent (KI_MAGNIFY_FULL_SCREEN) to activate full screen 
;		area mode.  If MagSendKeyEvent (KI_MAGNIFY_FULL_SCREEN) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, JFW reports "Full Screen magic view."
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagFullScreen ()
if (MagSendKeyEvent (KI_MAGNIFY_FULL_SCREEN)) then
	Say(mag028, OT_STATUS)
else
	Say(mag017, OT_MESSAGE)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagManualPanningKeyToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle the key used for manual panning between Alt + (direction) to Shift + (direction).
;		This script first calls the function MagGetOption (MPK_ALT) to determine the current manual panning key.
;		Then it calls the function MagSendKeyEvent (KI_MANUAL_PANNING_KEY_TOGGLE ) to toggle the current setting.
;		If MagSendKeyEvent (KI_MANUAL_PANNING_KEY_TOGGLE ) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, if the manual panning key was previously Alt, JFW reports "shift manual panning mode" and if the 
; 		manual panning key was previously shift JFW reports "alt manual panning mode."
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagManualPanningKeyToggle ()
var int nAlt
let nAlt = MagGetOption (MPK_ALT)
if (MagSendKeyEvent (KI_MANUAL_PANNING_KEY_TOGGLE )) then
	if (nAlt) then
		Say(mag030, OT_STATUS)
	else
		Say(mag029, OT_STATUS)
	endif
else
	Say(mag017, OT_MESSAGE)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		ShutDownMAGic ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to unload MAGic.  It accomplishes this by calling the built in function ShutDownMagic ().
;		If ShutDownMagic returns 0, JFW reports that "magic could not be unloaded."  Otherwise, JFW reports "magic 
;		unloaded."
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script ShutDownMAGic ()
;mag031 = "magic could not be unloaded",
;mag032 = "magic unloaded"
if (ShutDownMAGic ()) then
	Say(mag032, OT_MESSAGE)
else
	Say(mag031, OT_MESSAGE)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagManualPanningKeyToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to cause MAGic to switch to the next area mode.  
;		This script first calls the function MagGetOption (MID_AREA) to determine the current area mode.  Then it 
;		calls the function MagSendKeyEvent (KI_NEXT_MAGIC_VIEW) to toggle the current setting.
;		If MagSendKeyEvent (KI_NEXT_MAGIC_VIEW) returned 0, JFW reports "MAGic Not running."  
;		Otherwise, the script uses logic to determine what the new area mode is bassed upon the previous area 
;		mode and speaks the new area mode.
;		*** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagNextMAGicView ()
var int nView
let nView = MagGetOption (MID_AREA)
if (nView == 5) then
	let nView = 0
else
	let nView = nView + 1
endif
if (MagSendKeyEvent (KI_NEXT_MAGIC_VIEW)) then
;If the MAGic Window has focus, and the focus is actually
;in the MAGicView window, then don't speak the change.
;Highlighted text event will catch it.
	if (GetWindowClass(GetAppMainWindow (GetFocus())) == "JFWUI60") &&
		(GetControlID(GetFocus()) == 1026 /*MAGicView ID*/) then
		;Don't say anything.  Highlighted text will pick it up.
	else
		if 	(nView == 0) then Say(mag033, OT_STATUS)
		elif	(nView == 1) then Say(mag034, OT_STATUS)
		elif (nView == 2) then Say(mag035, OT_STATUS)
		elif (nView == 3) then Say(mag036, OT_STATUS)
		elif (nView == 4) then Say(mag037, OT_STATUS)
		elif (nView == 5) then Say(mag038, OT_STATUS) endif
	endif
else
	Say(mag017, OT_MESSAGE)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagNextMAGicMouseStyle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to cause MAGic to switch to the next magnified mouse style.  
;		This script does this by calling the function MagSendKeyEvent (M1_CUSTOM, KI_NEXT_MAGNIFIED_MOUSE_STYLE). 
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagNextMAGicMouseStyle ()
	MagNextMouseStyle(M1_CUSTOM, KI_NEXT_MAGNIFIED_MOUSE_STYLE)
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagNextRealMouseStyle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to cause MAGic to switch to the next unmagnified mouse style.  
;		This script does this by calling the function MagSendKeyEvent (M1_CUSTOM, KI_NEXT_UNMAGNIFIED_MOUSE_STYLE). 
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagNextRealMouseStyle ()
	MagNextMouseStyle(M0_CUSTOM, KI_NEXT_UNMAGNIFIED_MOUSE_STYLE)
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagResizeMAGicView ()
;Author's Name:
;		Ben Key
;Description:
;		This script is used to resize or move the magnified area. 
;		This script first calls MagGetState and MagGetArea and stores the return values in local variables.  If MAGic
;		is not running JFW reports "MAGic not running."  If MAGic is in Full Screen or Tracking Lens mode, JFW reports
;		"this magic view does not have sizeable borders."  Otherwise, this script calls the function
; 		MagSendKeyEvent (KI_SIZE_MAGIC_VIEW) to activate the resize view mode and JFW reports "magic resizing tool."
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagResizeMAGicView ()
var int nView, int nMagState
let nMagState = MagGetState()
let nView = MagGetOption (MID_AREA)
if (nMagState == -1) then
	Say (mag017, OT_MESSAGE)
elif (nMagState < 1) then
	Say (mag023, OT_MESSAGE)
elif (nView == 2 /*full screen*/ || nView == 5 /*tracking lens*/ ) then
	Say (mag047, OT_MESSAGE)
elif (MagSendKeyEvent (KI_SIZE_MAGIC_VIEW)) then
	Say (mag046, OT_MESSAGE)
else
	Say (mag017, OT_MESSAGE)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagSetSmoothingColorAtMouse ()
;Author's Name:
;		Ben Key
;Description:
;		This script is used to allow the user to customize background smoothing.   When this script is run, MAGic
;		sets the background color to the color at the current mouse position.  This has the same effect as activating
;		the background color selection tool and selecting the color.
;		This script performs this function primarily by calling the built in function MagSendKeyEvent (KI_SELECT_BG_COLOR_AT_MOUSE).
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagSetSmoothingColorAtMouse ()
;mag017 = "MAGic Not running"
;mag048 = " background smoothing color"
var int nX, int nY, int nColor
if (MagSendKeyEvent (KI_SELECT_BG_COLOR_AT_MOUSE)) then
	SaveCursor()
	JAWSCursor()
	let nColor = GetColorAtPoint(GetCursorCol (),GetCursorRow ())
	RestoreCursor ()
	if (nColor != -1) then
		SayString(GetColorName(nColor) + mag048)
	endif
else
	Say (mag017, OT_MESSAGE)
endif
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagShowMAGicMouseLocation ()
;Author's Name:
;		Ben Key
;Description:
;		This script activates the MAGic Mouse Locator tool.  When activated, this tool pulls back from the MAGicView 
;		that is currently active, and displays the RealView screen.  A miniature version of the current MAGicView 
;		is superimposed on the RealView along with a full-screen set of cross-hairs that pinpoint the location of the 
;		MAGic mouse pointer on both the RealView and the MAGicView.
;
;		This script performs this function primarily by calling the built in function 
;		MagSendKeyEvent (KI_SHOW_MAGNIFIED_MOUSE_LOCATION).
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagShowMAGicMouseLocation ()
;mag017 = "MAGic Not running"
If !(MagSendKeyEvent (KI_SHOW_MAGNIFIED_MOUSE_LOCATION)) then
	Say (mag017, OT_MESSAGE)
EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagShowRealMouseLocation ()
;Author's Name:
;		Ben Key
;Description:
;		This script activates the Real Mouse Locator tool.  When activated, this tool pulls back from the MAGicView 
;		that is currently active, and displays the RealView screen.  A miniature version of the current MAGicView 
;		is superimposed on the RealView along with a full-screen set of cross-hairs that pinpoint the location of the 
;		real mouse pointer on both the RealView and the MAGicView.
;
;		This script performs this function primarily by calling the built in function 
;		MagSendKeyEvent (KI_SHOW_UNMAGNIFIED_MOUSE_LOCATION).
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagShowRealMouseLocation ()
;mag017 = "MAGic Not running"
If !(MagSendKeyEvent (KI_SHOW_UNMAGNIFIED_MOUSE_LOCATION)) then
	Say (mag017, OT_MESSAGE)
EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagSmoothBackgroundColorSelector ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to activate the smooth background color selector.  This is done primarily by calling the 
;  	function MagSendKeyEvent (KI_START_BG_SMOOTH_COLOR_SELECTOR).
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagSmoothBackgroundColorSelector ()
Var Int nSpeechStatus
;mag017 = "MAGic Not running"
; mag049 = "Use the eye dropper to select the background color you wish to smooth"
Let nSpeechStatus = SpeechInUse ()
If !(MagSendKeyEvent (KI_START_BG_SMOOTH_COLOR_SELECTOR)) then
	If (nSpeechStatus) then Say (mag017, OT_MESSAGE) EndIf
Else
	If (nSpeechStatus) then
		Say (mag049, ot_help)
	EndIf
EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagSmoothBackgroundToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle background smoothing.
;		This script first calls the built in function MagGetOption (SMOOTH_BKGRND) to get the current background 
;		smoothing setting.  Then it calls the function MagSendKeyEvent (KI_BG_SMOOTH_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_BG_SMOOTH_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, JFW determines what the new background smoothing setting is by analyzing the previous setting
;		and reports the new setting.
;		** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagSmoothBackgroundToggle ()
; mag017 = "MAGic Not running"
; mag050 = "Background Smoothing On",
; mag051 = "Background Smoothing Off"
Var Int nSpeechStatus, Int bOn
Let nSpeechStatus = SpeechInUse ()
Let bOn = MagGetOption (SMOOTH_BKGRND)
If (MagSendKeyEvent (KI_BG_SMOOTH_TOGGLE)) then
	If (bOn) then
		If (nSpeechStatus) then Say (mag051, ot_status) EndIf
	Else
		If (nSpeechStatus) then Say (mag050, ot_status) EndIf
	EndIf
Else
	If (nSpeechStatus) then Say (mag017, OT_MESSAGE) EndIf
EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagSmoothToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle smoothing on or off.
;		This script first calls the built in function MagGetOption (SMOOTH_ON) to get the current smoothing setting.  
;		Then it calls the function MagSendKeyEvent (KI_SMOOTH_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_SMOOTH_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, JFW determines what the new smoothing setting is by analyzing the previous setting
;		and reports the new setting.
;		** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagSmoothToggle ()
; mag017 = "MAGic Not running"
; mag052 = "Smoothing On",
; mag053 = "Smoothing Off"
Var Int nSpeechStatus, Int bOn
Let nSpeechStatus = SpeechInUse ()
Let bOn = MagGetOption (SMOOTH_ON)
If (MagSendKeyEvent (KI_SMOOTH_TOGGLE)) then
	If (bOn) then
		If (nSpeechStatus) then Say (mag053, ot_status) EndIf
	Else
		If (nSpeechStatus) then Say (mag052, ot_status) EndIf
	EndIf
Else
	If (nSpeechStatus) then Say (mag017, OT_MESSAGE) EndIf
EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagTrackCursorMagicViewToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle cursor tracking on or off.
;		This script first calls the built in function MagGetOption (TID_CARET) to get the current caret tracking setting.  
;		Then it calls the function MagSendKeyEvent (KI_TRACK_CARET_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_TRACK_CARET_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, JFW determines what the new caret tracking setting is by analyzing the previous setting
;		and reports the new setting.
;		** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagTrackCursorMagicViewToggle ()
; mag017 = "MAGic Not running"
; mag054 = "Caret Tracking On",
; mag055 = "Caret Tracking Off"
Var Int nSpeechStatus, Int bOn
Let nSpeechStatus = SpeechInUse ()
Let bOn = MagGetOption (TID_CARET)
If (MagSendKeyEvent (KI_TRACK_CARET_TOGGLE)) then
	If (bOn) then
		If (nSpeechStatus) then Say (mag055, ot_status) EndIf
	Else
		If (nSpeechStatus) then Say (mag054, ot_status) EndIf
	EndIf
Else
	If (nSpeechStatus) then Say (mag017, OT_MESSAGE) EndIf
EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagTrackDialogToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle dialog box tracking on or off.
;		This script first calls the built in function MagGetOption (TID_DIALOG) to get the current dialog box tracking setting.  
;		Then it calls the function MagSendKeyEvent (KI_TRACK_DIALOG_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_TRACK_DIALOG_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, JFW determines what the new dialog box tracking setting is by analyzing the previous setting
;		and reports the new setting.
;		** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagTrackDialogToggle ()
; mag017 = "MAGic Not running"
; mag056 = "Dialog Tracking On",
; mag057 = "Dialog Tracking Off"
Var Int nSpeechStatus, Int bOn
Let nSpeechStatus = SpeechInUse ()
Let bOn = MagGetOption (TID_DIALOG)
If (MagSendKeyEvent (KI_TRACK_DIALOGS_TOGGLE)) then
	If (bOn) then
		If (nSpeechStatus) then Say (mag057, ot_status) EndIf
	Else
		If (nSpeechStatus) then Say (mag056, ot_status) EndIf
	EndIf
Else
	If (nSpeechStatus) then Say (mag017, OT_MESSAGE) EndIf
EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagTrackMenuToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle menu tracking on or off.
;		This script first calls the built in function MagGetOption (TID_MENU) to get the current menu tracking setting.  
;		Then it calls the function MagSendKeyEvent (KI_TRACK_MENUS_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_TRACK_MENUS_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, JFW determines what the new menu tracking setting is by analyzing the previous setting
;		and reports the new setting.
;		** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagTrackMenuToggle ()
; mag017 = "MAGic Not running"
; mag058 = "Menu Tracking On",
; mag059 = "Menu Tracking Off"
Var Int nSpeechStatus, Int bOn
Let nSpeechStatus = SpeechInUse ()
Let bOn = MagGetOption (TID_MENU)
If (MagSendKeyEvent (KI_TRACK_MENUS_TOGGLE)) then
	If (bOn) then
		If (nSpeechStatus) then Say (mag059, ot_status) EndIf
	Else
		If (nSpeechStatus) then Say (mag058, ot_status) EndIf
	EndIf
Else
	If (nSpeechStatus) then Say (mag017, OT_MESSAGE) EndIf
EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagTrackMouseToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle mouse tracking on or off.
;		This script first calls the built in function MagGetOption (TID_MOUSE) to get the current mouse tracking setting.  
;		Then it calls the function MagSendKeyEvent (KI_TRACK_MOUSE_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_TRACK_MOUSE_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, JFW determines what the new mouse tracking setting is by analyzing the previous setting
;		and reports the new setting.
;		** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagTrackMouseToggle ()
; mag017 = "MAGic Not running"
; mag060 = "Mouse Tracking On",
; mag061 = "Mouse Tracking Off"
Var Int nSpeechStatus, Int bOn
Let nSpeechStatus = SpeechInUse ()
Let bOn = MagGetOption (TID_MOUSE)
If (MagSendKeyEvent (KI_TRACK_MOUSE_TOGGLE)) then
	If (bOn) then
		If (nSpeechStatus) then Say (mag061, ot_status) EndIf
	Else
		If (nSpeechStatus) then Say (mag060, ot_status) EndIf
	EndIf
Else
	If (nSpeechStatus) then Say (mag017, OT_MESSAGE) EndIf
EndIf
EndScript

;*****************************************************************************************************************************************
;Script:	
;		MagTrackToggle ()
;Author's Name:
;		Ben Key
;Description:
;		This script is designed to toggle all MAGic tracking on or off.
;		This script first calls the built in function MagGetOption (TID_ON) to get the current MAGic tracking setting.  
;		Then it calls the function MagSendKeyEvent (KI_TRACK_TOGGLE) to toggle the current setting.
;		If MagSendKeyEvent (KI_TRACK_TOGGLE) returned 0, JFW reports that "MAGic Not running."  
;		Otherwise, JFW determines what the new tracking setting is by analyzing the previous setting
;		and reports the new setting.
;		** It is necessary to get the value of the option prior to toggleing the setting because the processing of the 
;		function MagSendKeyEvent (...) is given low priority compared to most of the other functions in MAGic.  If 
;		MagSendKeyEvent (...) were called and then MagGetOption (...) was called, the return value of MagGetOption (...)
;		may or may not reflect the change caused by MagSendKeyEvent (...) .  ***
;Parameters:
;		None
;Globals
;	Used:
;	Modified:
;Return Value:		None
;Other Information:
;*****************************************************************************************************************************************
;
;*****************************************************************************************************************************************
;					                          MODIFICATION LOG
;
;Date					Author						Description
;-----------------		---------------				-------------------------------------------------------------
;06/24/1999		Ben Key					Reorganization of MAGic tracking project
;*****************************************************************************************************************************************
Script MagTrackToggle ()
; mag017 = "MAGic Not running"
; mag062 = "Tracking On",
; mag063 = "Tracking Off"
Var Int nSpeechStatus, Int bOn
Let nSpeechStatus = SpeechInUse ()
Let bOn = MagGetOption (TID_ON)
If (MagSendKeyEvent (KI_TRACK_TOGGLE)) then
	If (bOn) then
		If (nSpeechStatus) then Say (mag063, ot_status) EndIf
	Else
		If (nSpeechStatus) then Say (mag062, ot_status) EndIf
	EndIf
Else
	If (nSpeechStatus) then Say (mag017, OT_MESSAGE) EndIf
EndIf
EndScript

Script ToggleMagFocusBetweenPromptAndControl ()
Var Int nL, Int nR, Int nT, Int nB, Int nX, Int nY, Int bSuccess
;  This script is used at higher levels of magnification to allow the user to switch between being able to see the prompt and the
;  control in a dialog box.  Below 10 X magnification, in most cases, both the control and the prompt are brought into view
;  automatically.  However, above 10 X magnification, this does not occur.  Therefore this script is provided to allow the user to
;  switch back and forth between seeing the control and the prompt.
If (!MagGetState () > 0) then Return EndIf
SayInteger (TargetItem)
If ((GetWindowName (GetRealWindow (GetFocus ())) == mWn_MAppWin)
  || (GetWindowSubtypeCode (GetRealWindow (GetFocus ())) == WT_DIALOG)
  || (DialogActive () == ACTIVE)) then
	Let nX = GetCursorCol ()
	Let nY = GetCursorRow ()
	If (GetWindowSubtypeCode (GetCurrentWindow ()) == WT_LISTVIEW) then
		Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_LINE)
		If (!bSuccess) then Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
		If (bSuccess) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
		EndIf
		If (TargetItem == 0) then
			Let TargetItem = 1
			MagSetFocusToRect (nL, nR + 3, nT, nB + 1, MTO_DIALOG)
		ElIf (TargetItem == 1) then
			Let TargetItem = 0
			MagFocusRight (nX, nY, nL, nR, nT, nB, MTO_DIALOG)
		EndIf
		Return
	EndIf
	If (TargetItem == 0) then
	  Let TargetItem = 1
	  If (GetItemRect (nX, nY, nL, nR, nT, nB, IT_PROMPT)) then
	    MagSetFocusToRect (nL - 3, nR + 3, nT - 3, nB + 3, MTO_DIALOG)
	  Else
	    GetPromptRectAlternative (nL, nR, nT, nB, 0)
	    MagSetFocusToRect (nL - 3, nR + 3, nT - 3, nB + 3, MTO_DIALOG)
	  EndIf
	ElIf (TargetItem == 1) then
	  Let TargetItem = 0
	  MagSetFocusArea (GetCursorCol (), GetCursorRow (), 0, 0, 0, 0, 0, TargetItem)
	EndIf
Else
		If (TargetItem == 0) then
			Let TargetItem = 1
			MagSetFocusArea (GetCursorCol (), GetCursorRow (), 0, 0, 0, 0, 0, TargetItem)
		ElIf (TargetItem == 1) then
			Let TargetItem = 0
			MagSetFocusArea (GetCursorCol (), GetCursorRow (), 0, 0, 0, 0, 0, TargetItem)
		EndIf
EndIf
EndScript

String Function GetPriorWord ()
Var string strWord, Int nL, Int nR, Int nT, Int nB, Int bSuccess
Let bSuccess = GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_PRIOR_WORD)
If (bSuccess) then Let strWord = GetTextBetween (nL, nR)
Else
	SaveCursor ()
	If (IsPCCursor ()) then
		RouteInvisibleToPc ()
		InvisibleCursor ()
		PriorWord ()
		Let strWord = GetWord ()
	ElIf (IsJAWSCursor ()) then
		RouteInvisibleToJAWS ()
		InvisibleCursor ()
		PriorWord ()
		Let strWord = GetWord ()
	EndIf
	RestoreCursor ()
EndIf
Return strWord
endFunction

String Function GetNextWord ()
Var string strWord, Int nL, Int nR, Int nT, Int nB, Int bSuccess
Let bSuccess = GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_NEXT_WORD)
If (bSuccess) then Let strWord = GetTextBetween (nL, nR)
Else
	SaveCursor ()
	If (IsPCCursor ()) then
		RouteInvisibleToPc ()
		InvisibleCursor ()
		NextWord ()
		Let strWord = GetWord ()
	ElIf (IsJAWSCursor ()) then
		RouteInvisibleToJAWS ()
		InvisibleCursor ()
		NextWord ()
		Let strWord = GetWord ()
	EndIf
	RestoreCursor ()
EndIf
Return strWord
EndFunction

Int Function MagGetState ()
	if (FindTopLevelWindow ("JFWUI60", "") == 0) then return -1 endif
	if (MagGetOption (MID_ON) == FALSE) then	return 0 endif
	return MagGetOption (MID_LEVEL)
EndFunction

Void Function MagNextMouseStyle (int nOption, int nKeyEvent)
var int nStyle
let nStyle = MagGetOption (nOption)
if (nStyle == 6) then let nStyle = 0
else let nStyle = nStyle + 1 endif
if (MagSendKeyEvent (nKeyEvent)) then
	if 	(nStyle == 0) then Say(mag039, OT_STATUS)
	elif	(nStyle == 1) then Say(mag040, OT_STATUS)
	elif (nStyle == 2) then Say(mag041, OT_STATUS)
	elif (nStyle == 3) then Say(mag042, OT_STATUS)
	elif (nStyle == 4) then Say(mag043, OT_STATUS)
	elif (nStyle == 5) then Say(mag044, OT_STATUS)
	elif (nStyle == 6) then Say(mag045, OT_STATUS) endif
else
	Say(mag017, OT_MESSAGE)
endif
EndFunction

Int Function GetDialogControlRect (int nX, int nY, int ByRef nL, int ByRef nR, int ByRef nT, int ByRef nB, int nType, handle hTarget)
Var Int bSuccess, Int nL1, Int nR1, Int nT1, Int nB1, Int nL2, Int nR2, Int nT2, Int nB2
If (!MagGetState () > 0) then Return -1 EndIf
; Initialize Variables
Let bSuccess = 0
Let nL1 = 0  Let nR1 = 0  Let nT1 = 0  Let nB1 = 0
Let nL2 = 0  Let nR2 = 0  Let nT2 = 0  Let nB2 = 0
Let nL = 0  Let nR = 0  Let nT = 0  Let nB = 0
If (!hTarget && nX != 0 && nY != 0) then Let hTarget = GetWindowAtPoint (nX, nY)
ElIf (!hTarget && nX == 0 && nY == 0) then Let hTarget = GetCurrentWindow () EndIf
If (nType == IT_PROMPT | IT_BOUNDINGRECT) then
	Let bSuccess = GetItemRect (nX, nY, nL1, nR1, nT1, nB1,  IT_PROMPT)
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL1, nR1, nT1, nB1,  IT_PROMPT) EndIf
	RestoreCursor ()
;	If (!bSuccess) then Say("Could not get prompt rect",ot_debug) EndIf
	If (GetWindowClass (hTarget) != "RichEdit20W") then
		Let bSuccess = GetFocusRect (hTarget, nL2, nR2, nT2, nB2)
		If (!bSuccess) then
			Let nL2 = GetWindowLeft (hTarget)
			Let nR2 = GetWindowRight (hTarget)
			Let nT2 = GetWindowTop (hTarget)
			Let nB2 = GetWindowBottom (hTarget)
		EndIf
		Let nR2 = nR2 + 15
	Else
		Let nL2 = GetWindowLeft (hTarget)
		Let nR2 = GetWindowRight (hTarget)
		Let nT2 = GetWindowTop (hTarget)
		Let nB2 = GetWindowBottom (hTarget)
		Let nR2 = nR2 + 15
	EndIf
	If (nL2 == 0 && nR2 == 0 && nT2 == 0 && nB2 == 0) then Say ("Could not get hTarget rect", ot_debug) Return 0 EndIf
	If (nL1 > nL2) then Let nL = nL2
	ElIf (nL2 > nL1) then Let nL = nL1
	ElIf (nL1 == nL2) then Let nL = nL1 EndIf
	If (nR1 > nR2) then Let nR = nR1
	ElIf (nR2 > nR1) then Let nR = nR2
	ElIf (nR1 == nR2) then Let nR = nR1 EndIf
	If (nT1 > nT2) then Let nT = nT2
	ElIf (nT2 > nT1) then Let nT = nT1
	ElIf (nT1 == nT2) then Let nT = nT1 EndIf
	If (nB1 > nB2) then Let nB = nB1
	ElIf (nB2 > nB1) then Let nB = nB2
	ElIf (nB1 == nB2) then Let nB = nB1 EndIf
	If (nL == 0 && nR == 0 && nT == 0 && nB == 0) then Say ("No rectangle obtained", ot_debug) Return 0
	ElIf (nT < nB && nL < nR) then Return 1
	Else Return 0 EndIf
ElIf (nType == IT_BOUNDINGRECT) then
	If (GetWindowClass (hTarget) != "RichEdit20W") then
		Let bSuccess = GetFocusRect (hTarget, nL, nR, nT, nB)
		If (!bSuccess) then
			Let nL = GetWindowLeft (hTarget)
			Let nR = GetWindowRight (hTarget)
			Let nT = GetWindowTop (hTarget)
			Let nB = GetWindowBottom (hTarget)
		EndIf
		Let nR = nR + 15
	Else
		Let nL = GetWindowLeft (hTarget)
		Let nR = GetWindowRight (hTarget)
		Let nT = GetWindowTop (hTarget)
		Let nB = GetWindowBottom (hTarget)
		Let nR = nR + 15
	EndIf
	If (nL == 0 && nR == 0 && nT == 0 && nB == 0) then Return 0 Else Return 1 EndIf
Else
	Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB,  IT_PROMPT)
	SaveCursor () JAWSCursor () MoveTo (nR, nB) RestoreCursor ()
	Return bSuccess
EndIf
EndFunction

Int Function MagSetFocusArea (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed, int nTargetItem)
;  This function is designed to be a universal function that controls nearly all aspects of MAGic tracking.  It has
;  several sections that are designed for a specific purpose.  The first section is designed to handle tracking of
;  the caret in all multi-line edit windows.  The second section is designed to handle tracking in the start menu.
;  The third section controls MAGic tracking in application menus.  The fourth section controls tracking in dialog
;  boxes.  The fifth section controls tracking in list views.  The final section is designed to be generic and handle
;  the tracking of all other items.
Var
	Int TheTypeCode,		;  Holds the Window Sub Type Code of the current window
	String cwClass,		;  Holds the Window Class of the current window
	Handle AppWindow,		;  Holds the Window Handle of the application main window
	Int nTest			;  Stores the return values of the functions
	; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
If (!MagGetState () > 0) then Return 0 EndIf
	; Initialize the variables
Let nTest = 0
let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
let cwClass = GetWindowClass (GetCurrentWindow ())
Let AppWindow = GetAppMainWindow (GetFocus ())
	;  Set the MAGic focus in the Start Menu
if (TheTypeCode == WT_STARTMENU) then
	return FALSE
ElIf (GlobalMenuMode != MENU_INACTIVE) then
	Let nTest = TrackApplicationMenus (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TheTypeCode, cwClass, AppWindow, nTargetItem)
	if (nTest == 1) then return 1 EndIf
	;  Set the MAGic Focus if the active window is a control in a dialog box
ElIf ((GetWindowName (GetRealWindow (GetFocus ())) == mWn_MAppWin)
	|| (GetWindowSubtypeCode (GetRealWindow (GetFocus ())) == WT_DIALOG)
	|| (DialogActive () == ACTIVE)) then
		Let nTest = TrackDialogBoxes (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TheTypeCode, cwClass, AppWindow)
		If (nTest == 1) then Return 1 EndIf
		;  Set the MAGic focus in multi-line edit windows
ElIf (StringContains (WindowClassListR, cwClass) == TRUE || StringContains (WindowTypeListR, IntToString (TheTypeCode)) ==TRUE) then
	If (GlobalMenuMode == MENU_INACTIVE) then
		Let nTest = TrackEditWindow (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TheTypeCode, cwClass, AppWindow, nTargetItem)
		If (nTest == 1) then Return 1 EndIf
	EndIf
	;  This block of code is designed to set the MAGic focus in a list view.  Two different approaches to setting the
	;  MAGic focus are employed.  The deciding factor in which method is used is the level of magnification.
ElIf (TheTypeCode == WT_LISTVIEW) then
	Let nTest = TrackListView (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TheTypeCode, cwClass, AppWindow, nTargetItem)
	If (nTest == 1) then Return 1 EndIf
Else
	;  This block of code is designed to be generic to apply to most items
	Let nTest = TrackGeneral (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TheTypeCode, cwClass, AppWindow, nTargetItem)
	If (nTest == 1) then Return 1 EndIf
EndIf
Return nTest
EndFunction

Int Function TrackEditWindow (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed, Int TheTypeCode, String cwClass, Handle appWindow, int nTargetItem)
;  This function is called by MagSetFocusArea to handle MAGic tracking in edit windows
Var    Int bSuccess, Int nMaxWidth, Int nL, Int nR, Int nT, Int nB, Int nLevel
Let nLevel = MagGetOption (MID_LEVEL)
Let bSuccess = FALSE
Let nMaxWidth = ScreenGetWidth () / nLevel
If (cwClass == mWN_IEWin) then
	If (GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT) == TRUE && GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == FALSE) then Return 0 EndIf
EndIf
Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD)
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD) EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_CHAR) EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_CARET)  EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD) EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHAR) EndIf
If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) EndIf
If (nT <= 10) then Let nT = 0 Else Let nT = nT - 10 EndIf
If (nL <= 10) then Let nL = 0 Else Let nL = nL - 10 EndIf
;If (GetAppFileName () == NotePadApp) then
  Let nR = nR + ((nR - nL)/3)
;EndIf
If (bSuccess) then
	If ((nR - nL) > nMaxWidth) then Let nR = nX + 15
		If ((nR - nL) > nMaxWidth) then Let nL = nR - nMaxWidth EndIf
		If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_CARET)
		Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_CARET) EndIf
		Return 1
	Else
		If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_CARET)
		Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_CARET) EndIf
	EndIf
	Return 1
Else
	Return bSuccess
EndIf
EndFunction

Int Function TrackStartMenu (handle hStartMenu, int nTargetItem)
var handle hWnd, int nLeft, int nTop, int nRight, int nBottom
if (hStartMenu) then let hWnd = hStartMenu
else let hWnd = GetCurrentWindow() EndIf
if (GetWindowSubTypeCode(hWnd) == WT_STARTMENU) then
	if (GetItemRect (0, 0, nLeft, nRight, nTop, nBottom, IT_HIGHLIGHT)) then
		let nRight = GetWindowRight (hWnd) - 5
	If (nTargetItem == 0) then
		MagSetFocusToRect (nLeft - 2, nRight, nTop, nBottom, MTO_MENUS)
	ElIf (nTargetItem == 1) then
		MagFocusRight (0, 0, nLeft - 2, nRight, nTop, nBottom, MTO_MENUS)
	EndIf
	return TRUE
 endif
else return FALSE endif
EndFunction

Int Function TrackApplicationMenus (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed, int TheTypeCode, string cwClass, handle appWindow, int nTargetItem)
;  This function is called by MagSetFocusArea to handle MAGic tracking in application menus
Var Int bSuccess, Int nL, Int nR, Int nT, Int nB
 ; Test variable used to determine if a function completed sucessfully or not.
Let bSuccess = FALSE
If (MagMenuMode == MENU_INACTIVE) then Return 0 EndIf
; Control MAGic Tracking in Menu Bars
If (MagMenuMode == MENUBAR_ACTIVE) then
 ; Prevent jumpiness when using the mouse to activate one of the combo boxes in the
 ; Microsoft Office tool bars.  When the combo box is the active item (it contains a
 ; cursor) it has a window class of Edit.  In order to prevent focus from jumping to the
 ; top left corner of the screen (the location of the application context menu, handle
 ; the case of windows with class Edit in the menu bars here
	If (cwClass == mWC_Edit && GetWindowClass (GetParent (GetCurrentWindow ())) == mWN_OfficeBar) then
		Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
		If (!bSuccess) then  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT) EndIf
		If (nTargetItem == 0) then MagSetFocusToRect (nL - 2, nR + 2, nT - 2, nB + 2, MTO_MENUS)
		Else MagFocusRight (nX, nY, nL - 2, nR + 2, nT - 2, nB + 2, MTO_MENUS) EndIf
		Return 1
 ;  This block of code is used to set the MAGic focus on toolbar icons
 ;  in Microsoft Office when navigated using the keyboard.  It is necessary because all
 ;  of the functions that return a rectangle fail to return a rectangle when the
 ;  Applcation Control Menu is selected.
 ; If the currently selected item is a icon on a Microsoft Office toolbar, set the MAGic focus to the bounding rectangle.
	ElIf (cwClass == mWN_OfficeBar) then
		If (GetCharacterAttributes () != ATTRIB_GRAPHIC && GetObjectTypeCode () != WT_COMBOBOX) then
			If (GetNextWord () != "minimize symbol") then
				Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD | IT_NEXT_WORD)
			Else
				Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD)
				Let nR = nR + 20
			EndIf
			If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD) EndIf
		Else
			Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
			Let nR = nR + 20
		EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT) EndIf
		If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
		If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
		If (nTargetItem == 0) then MagSetFocusToRect (nL, nR, nT, nB + 3, MTO_MENUS)
		Else MagFocusRight (nX, nY, nL, nR, nT, nB + 3, MTO_MENUS) EndIf
		Return 1
	Else
		Delay (1)
  ; This block of code is generic to all menu bars
		If (GetNextWord () != "minimize symbol") then
			Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD | IT_NEXT_WORD)
		Else
			Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD)
			Let nR = nR + 20
		EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_PRIOR_WORD | IT_WORD) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
		If (bSuccess) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			If (nTargetItem == 0) then MagSetFocusToRect (nL, nR, nT, nB + 3, MTO_MENUS)
			Else MagFocusRight (nX, nY, nL, nR, nT, nB + 3, MTO_MENUS) EndIf
			Return 1
		Else
  ; Otherwise, set the MAGic focus to the top left corner of the main application window. (the location of the application
  ; control menu.
			Let nL = GetWindowLeft(appWindow)
			Let nT = GetWindowTop(appWindow)
			Let nR = nL + 25
			Let nB = nT + 25
			If (nTargetItem == 0) then MagSetFocusToRect (nL, nR, nT, nB + 3, MTO_MENUS)
			Else MagFocusRight (nX, nY, nL, nR, nT, nB + 3, MTO_MENUS) EndIf
			Return 1
		EndIf
	EndIf
EndIf
If (MagMenuMode == MENU_ACTIVE) then
	Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB)
	If (!bSuccess) then Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB) EndIf
	If (bSuccess) then
		If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
		If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
		If (nTargetItem == 0) then MagSetFocusToRect (nL, nR, nT, nB + 3, MTO_MENUS)
		Else MagFocusRight (nX, nY, nL, nR, nT, nB + 3, MTO_MENUS) EndIf
		Return 1
	Else
		Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB)
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_HIGHLIGHT) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
		If (!bSuccess) then Return 0 Else
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			Let nR = GetWindowLeft (GetCurrentWindow ())
			If (nTargetItem == 0) then MagSetFocusToRect (nL, nR, nT, nB + 3, MTO_MENUS)
			Else MagFocusRight (nX, nY, nL, nR, nT, nB + 3, MTO_MENUS) EndIf
			Return 1
		EndIf
	EndIf
EndIf
EndFunction

Int Function TrackDialogBoxes (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed, Int TheTypeCode, String cwClass, Handle appWindow)
;  This function is called by MagSetFocusArea to handle MAGic tracking in dialog boxes
Var int nH,  int nW, Int nL, Int nR, Int nT, Int nB, Int nLevel, Int bSuccess
If (GlobalMenuMode != MENU_INACTIVE) then Return 0 EndIf
Let nLevel = MagGetOption (MID_LEVEL)
GetWindowRect (GetRealWindow (GetFocus ()), nL, nR, nT, nB)
Let nH = nB - nT
Let nW = nR - nL
If (TestDialogSize (nW, nH) == 1) then
	MagSetFocusToRect (nL, nR, nT, nB, MTO_DIALOG)
	Return 1
Else
	If (TheTypeCode == WT_LISTVIEW) then
		Let bSuccess = TrackListView (nX, nY, nOldX, nOldY, nUnit, nDir, nTimeElapsed, TheTypeCode, cwClass, appWindow, 0)
		Return bSuccess
	EndIf
	If (nLevel < DialogControlAndPromptMax) then
		If (GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT | IT_PROMPT)) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			MagSetFocusToRect (nL, nR + 3, nT, nB + 3, MTO_DIALOG)
			Return 1
		ElIf (GetDialogControlRect (nY, nY, nL, nR, nT, nB, IT_PROMPT | IT_BOUNDINGRECT, 0)) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			MagSetFocusToRect (nL, nR + 3, nT, nB + 3, MTO_DIALOG)
			Return 1
		Else Return 0 EndIf
	Else
		If (GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			MagSetFocusToRect (nL, nR + 3, nT, nB + 3, MTO_DIALOG)
			Return 1
		ElIf (GetDialogControlRect (nY, nY, nL, nR, nT, nB, IT_BOUNDINGRECT, 0)) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			MagSetFocusToRect (nL, nR + 3, nT, nB + 3, MTO_DIALOG)
			Return 1
		Else Return 0 EndIf
	EndIf
EndIf
EndFunction

Int Function TestDialogSize (int nW, int nH)
Var Int nMaxW, Int nMaxH, Int nAreaMode, Int nLevel,
	Int mW, Int mH, Int mL, Int mR, Int mT, Int mB
If (!MagGetState () > 0) then Return 0 EndIf
Let nLevel = MagGetOption (MID_LEVEL)
Let nAreaMode = MagGetArea ()
If (nAreaMode == MA_FULL_SCREEN || nAreaMode == MA_TRLENS) then
	Let nMaxW = ScreenGetWidth ()
	Let nMaxH = ScreenGetHeight ()
	If (nW * nLevel > nMaxW || nH * nLevel > nMaxH) then Return 0 Else Return 1 EndIf
Else
	GetItemRect (0, 0, mL, mR, mT, mB, IT_MAGNIFIED)
	Let mW = mR - mL
	Let mH = mB - mT
	If (mW < nW || mH < nH) then Return 0 Else Return 1 EndIf
EndIf
EndFunction

Int Function TrackListView (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed, int TheTypeCode, string cwClass, handle appWindow, int nTargetItem)
Var Int nL, Int nR, Int nT, Int nB, Int nLevel, Int bSuccess
Let bSuccess = FALSE
Let nLevel = MagGetOption (MID_LEVEL)
;  This function is called by MagSetFocusArea to handle MAGic tracking in list views
;  At levels of magnification less than ListViewIconMax (currently set in mconst.jsh), the function GetItemRect with
;  a IT_BOUNDINGRECT flag is used.  When used in a list view in this manner, GetItemRect returns a rectangle that
;  surrounds the highlighted text and the icon associated with the text.  The rectangle is then passed to
;  MagSetFocusToRect.
If (nLevel < ListViewIconMax) then
	Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_HIGHLIGHT) EndIf
	If (!bSuccess) then Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB) EndIf
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
	If (bSuccess) then
		If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
		If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
		If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_CARET)
		Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_CARET) EndIf
	EndIf
Else
;  At levels of magnification greater than ListViewIconMax (currently set in mconst.jsh), the function GetItemRect with
;  a IT_CHUNK flag is used.  GetItemRect returns a rectangle that surrounds the highlighted text in the list view.
;  The rectangle is then passed to MagSetFocusToRect.
	Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_HIGHLIGHT)
	If (!bSuccess) then Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB) EndIf
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
	If (bSuccess) then
		If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
		If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
		If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_CARET)
		Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_CARET) EndIf
	EndIf
EndIf
Return bSuccess
EndFunction

Int Function TrackGeneral (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed, int TheTypeCode, string cwClass, handle appWindow, int nTargetItem)
;  This function is called by MagSetFocusArea to handle MAGic tracking of all other items
Var    Int bSuccess, Int nL, Int nR, Int nT, Int nB
Let bSuccess = FALSE
;  In windows with a class of Internet Explorer_Server, attempt to obtain a bounding rectangle arround the current
; item first.  If that fails, then attempt to obtain a rectangle arround the current chunk, followed by the current field, and
; the current window.
If (cwClass == mWN_IEWin) then
	Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
	If (!bSuccess) then Let bSuccess = GetFocusRect (GetCurrentWindow (), nL, nR, nT, nB) EndIf
	If (!bSuccess) then Let bSuccess = GetCurrentWindowRect (nL, nR, nT, nB) EndIf
	If (nT <= 3) then Let nT = 0 Else Let nT = nT - 3 EndIf
	If (nL <= 3) then Let nL = 0 Else Let nL = nL - 3 EndIf
	If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_GENERIC)
	Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_GENERIC) EndIf
	Return 1
ElIf (cwClass == mWN_STV32) then
	Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD)
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
	Let nR = GetWindowRight (GetCurrentWindow ())
	If (nT <= 3) then Let nT = 0 Else Let nT = nT - 3 EndIf
	If (nL <= 3) then Let nL = 0 Else Let nL = nL - 3 EndIf
	If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_GENERIC)
	Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_GENERIC) EndIf
	Return 1
ElIf (cwClass == mWN_SPG) then
	GetLineRect (0, 0, nL, nR, nT, nB)
	If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_GENERIC)
	Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_GENERIC) EndIf
	Return
Else
; In all other windows, attempt to obtain a rectangle arround the current chunk first.  If that fails, then attempt to obtain
; a rectangle arround the current field, followed by a bounding rectangle around the currently selected item, and
; the current window.
	Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK)
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
	If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT) EndIf
	If (!bSuccess) then Let bSuccess = GetFocusRect (GetCurrentWindow (), nL, nR, nT, nB) EndIf
	If (!bSuccess) then Let bSuccess = GetCurrentWindowRect (nL, nR, nT, nB) EndIf
EndIf
If (!bSuccess) then Return 0
Else
	If (cwClass == mWN_ListBox) then
		Let nL = GetWindowLeft (GetCurrentWindow ())
		Let nR = GetWindowRight (GetCurrentWindow ())
	EndIf
	If (nT <= 3) then Let nT = 0 Else Let nT = nT - 3 EndIf
	If (nL <= 3) then Let nL = 0 Else Let nL = nL - 3 EndIf
	If (nTargetItem == 0) then MagSetFocusToRect (nL, nR + 5, nT, nB + 5, MTO_GENERIC)
	Else MagFocusRight (nX, nY, nL, nR + 5, nT, nB + 5, MTO_GENERIC) EndIf
	Return 1
EndIf
EndFunction

Void Function MagSetFocusToRect (int nL, int nR, int nT, int nB, int nType)
;  Causes Magic to set focus to a given rectangle.  If any point in the rectangle is not visible on the screen,
;  the screen is panned to make that point visible.
Var Int nAreaMode, Int nTest
Let nTest = 0
Let nAreaMode = MagGetArea ()
If (nAreaMode != MA_TRLENS) then
	MagSetFocusToRect (nL, nR, nT, nB, nType)
	Return
Else
	Let nTest = MagSetFocus (nL, nR, nT, nB, MF_TRACK_LENS_OVER_RECT, nType)
	Return
endIf
EndFunction

Void Function SetMagicFocus (handle FocusWindow, handle PrevWindow)
Var Int nL, Int nR, Int nT, Int nB
;  This function is called by FocusChangedMagEvent if MagSetFocusArea returns 0.  Its purpose is to set
;  the MAGic focus so that at least a portion of the active window is brought into view under those rare
;  circumstances in which MAGic is not able to set focus to a more specific object.
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
If (!GetFocusRect (FocusWindow, nL, nR, nT, nB)) then
	GetItemRect (0, 0, nL, nR, nT, nB, IT_BOUNDINGRECT)
endif
MagSetFocusToRect (nL, nR, nT, nB, MTO_GENERIC)
EndFunction

Void Function GetPromptRectAlternative (int ByRef nL, int ByRef nR, int ByRef nT, int ByRef nB, int Flag)
;  This function is designed to be called by ToggleMagFocusToPrompt in those circumstances in which
;  GetItemRect with a IT_PROMPT flag fails to return a rectangle.  This function currently assumes that
;  the prompt is located directly prior to the control.
Var   Int nOldR
If (!MagGetState () > 0) then Return EndIf
Let nOldR = nR
SaveCursor ()
RouteInvisibleToPc ()
InvisibleCursor ()
PriorChunk ()
GetItemRect (0, 0, nL, nR, nT, nB, IT_CHUNK)
RestoreCursor ()
If (Flag == 0) then

ElIf (Flag == 1) then
	Let nR = nOldR
EndIf
EndFunction

Int Function GetCurrentWindowRect (int ByRef nL, int ByRef nR, int ByRef nT, int ByRef nB)
;  This function is designed to be called by TrackEditWindow in those circumstances in which
;  GetItemRect with all available flags fail to return a rectangle.  This function obtains a
;  rectangle that surrounds the currently active window.
Var Handle cWin
If (!MagGetState () > 0) then Return 0 EndIf
Let nL = 0    Let nR = 0    Let nT = 0    Let nB = 0
Let cWin = GetCurrentWindow ()
Let nL = GetWindowLeft (cWin)
Let nR = GetWindowRight (cWin)
Let nT = GetWindowTop (cWin)
Let nB = GetWindowBottom (cWin)
If (nL == 0  && nR == 0 && nT == 0 && nB == 0) then Return 0 Else Return 1 EndIf
EndFunction

Int Function GetLineRect (int nX, int nY, int ByRef nL, int ByRef nR, int ByRef nT, int ByRef nB)
;  This function is designed to be called by TrackStartMenu, TrackApplicationMenus, and several other
;  functions in those circumstances in which a rectangle that is the height of the text on the current
;  window and the width of the current window is desired.
Var int bSuccess
If (!MagGetState () > 0) then Return 0 EndIf
Let bSuccess = FALSE
Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_LINE)
If (!bSuccess) then Delay (1) Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_LINE) EndIf
If (!bSuccess) then Delay (1) Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_HIGHLIGHT) EndIf
If (!bSuccess) then Delay (1) Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
If (!bSuccess) then Return 0 Else Let nL = GetWindowLeft (GetCurrentWindow ()) Let nR = GetWindowRight (GetCurrentWindow ()) EndIf
Return bSuccess
EndFunction

Int Function MagFocusRight (int nX, int nY, int nL, int nR, int nT, int nB, int nType)
Var Int nW, Int nH, Int nMaxWidth, Int nMaxHeight, Int nLevel
If (!MagGetState () > 0) then Return EndIf
Let nLevel = MagGetOption (MID_LEVEL)
Let nMaxWidth = ScreenGetWidth () / nLevel
Let nMaxHeight = ScreenGetHeight () / nLevel
Let nW = nR - nL
Let nH = nB - nT
If ((nH < nMaxHeight) && (nW < nMaxWidth)) then MagSetFocusToRect (nL, nR, nT, nB, nType) EndIf
If ((nH > nMaxHeight) && (nW > nMaxWidth)) then
	Let nL = nR - nMaxWidth
	Let nT = nB - nMaxHeight
	MagSetFocusToRect (nL, nR, nT, nB, nType)
ElIf ((nH > nMaxHeight) && (nW < nMaxWidth)) then
	Let nT = nB - nMaxHeight
	MagSetFocusToRect (nL, nR, nT, nB, nType)
ElIf ((nH < nMaxHeight) && (nW > nMaxWidth)) then
	Let nL = nR - nMaxWidth
	MagSetFocusToRect (nL, nR, nT, nB, nType)
EndIf
EndFunction

Int Function DidControlChange ()
Var Handle prevWinHandle, Int nX, Int nY
If (!MagGetState ()) then Return EndIf
Let nX = GetCursorCol ()
Let nY = GetCursorRow ()
Let prevWinHandle = cwHandle
Let cwHandle = GetWindowAtPoint (nX, nY)
If ((GetWindowName (GetRealWindow (GetFocus ())) == mWN_MAppWin)
	|| (GetWindowSubtypeCode (GetRealWindow (GetFocus ())) == WT_DIALOG)
	|| (DialogActive () == ACTIVE)) then
	If (GlobalMenuMode == MENU_INACTIVE && cwHandle != prevWinHandle) then Return 1 EndIf
Else Return 0 EndIf
EndFunction

; **/MagEvent  Beginning of MAGic Event functions
Void Function ScreenMagnifiedEvent (int nOn, int nLevel)
;  This function first sets the value of two global variables, GlobalMagState and GlobalMagLevel.
;  These values are set according to the values passed to the function as parameters.  Once the
;  global variables have been defined, the function runs FocusChangedMagEvent twice in effort
;  to ensure that the activated item is brought into focus.
Var Int bSuccess
Let bSuccess = FALSE
Let TargetItem = 0
If (nOn == 1) then
	Let bSuccess = MagSetFocusArea (GetCursorCol (), GetCursorRow (), 0, 0, 0, 0, 0, TargetItem)
;  Sometimes when an edit window, MAGic focus is not set to the cursor position the first time that MagSetFocusArea is
;  called.  This happens especially when the cursor is located at the top of the document.  In order to resolve this issue
;  and cause MAGic to behave more consistently, call MagSetFocusArea once more.
	If (!bSuccess) then Delay (2) Let bSuccess = MagSetFocusArea (GetCursorCol (), GetCursorRow (), 0, 0, 0, 0, 0, TargetItem) EndIf
EndIf
EndFunction

Function MouseMovedEvent (int x, int y)
Let TargetItem = 0
EndFunction

Globals String curApp
; **/focus
Void Function FocusChangedMagEvent (handle FocusWindow, handle PrevWindow)
;  This function is designed to handle all MAGic specific processing that must occur
;  when the focus changes.  The window handles of the previous and new windows
;  are passed to this function to aid in the analysis of the focus change.
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
Var String prevApp
Let TargetItem = 0
Let prevApp = curApp
Let curApp = GetAppFileName ()
If (prevApp != curApp) then Delay (5) EndIf
MagSetFocusArea (GetCursorCol (), GetCursorRow (), 0, 0, 0, 0, 0, TargetItem)
EndFunction

Void Function ActiveItemChangedMagEvent ()

EndFunction

; **/pm
Void Function FocusPointMovedMagEvent (int nX, int nY, int nOldX, int nOldY, int nUnit, int nDir, int nTimeElapsed)
;  This function first tests for the existance of MAGic.  If MAGic is running, it then determines
;  the current window type.  If the current window type is an edit Window, it calls
;  SetMagicFocusArea to set the focus to a region surrounding the cursor position.
;  Test to determine if there is an application specific setting in the jcf file to disable the JFW tracking engine.
; Test for the existance of MAGic.  If MAGic is not running, return without doing any further processing.
If (!MagGetState ()) then Return EndIf
If (DidControlChange () == 1) then Return EndIf
If (GetWindowSubTypeCode (GetCurrentWindow ()) == WT_STARTMENU) then Return EndIf
Let TargetItem = 0
If (GetCursorCol () - nX == 1) then Let nX = nX + 1 EndIf
MagSetFocusArea (nX, nY, nOldX, nOldY, nUnit, nDir, NTimeElapsed, TargetItem)
EndFunction

Void Function NewTextMagEvent (handle hwnd, string buffer, int nAttributes, int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
;  When this function is called, it receives information pertaining to the newly written text.
;  It then analyzes the newly written text to determine if there is a need to adjust the
;  MAGic focus so that the newly written text is brought into view.
Var    String TheClass,    String cwClass,    Int TheTypeCode,     Int cwTypeCode,
  Int nH,    Int bSuccess,  Int nX,   Int nY, Handle prevWinHandle, int nLeft, int nTop,
  int nRight, int nBottom, Int nL, Int nR, Int nT, Int nB
; Exit without any further processing if MAGic is not running
If (!MagGetState ()) then Return EndIf
; Innitialize the variables that must be initialized in order to make the decision about whether or not to allow the function to continue running first.
let TheClass = GetWindowClass(hwnd)
let TheTypeCode = GetWindowSubtypeCode (hwnd)
let cwClass = GetWindowClass (GetCurrentWindow ())
let cwTypeCode = GetWindowSubtypeCode (GetCurrentWindow ())
;  Allways allow NewTextMagEvent to control tracking in the start menu and the alt + tab dialog box
if ((cwTypeCode == WT_STARTMENU) && (nAttributes & ATTRIB_HIGHLIGHT)) then TrackStartMenu(hwnd, TargetItem) Let TargetItem = 0 Return EndIf
;wnAltTab="#32771"
If (TheClass == wnAltTab) then
	If (!GetWindowRect (hwnd, nL, nR, nT, nB)) then return EndIf
	let nH = nB - nT
	let nT = nT + ((50 * nH) / 100)
	MagSetFocusToRect (nL, nR + 10, nT, nB + 5, MTO_GENERIC)
	return
EndIf
;***  Make the decision about whether or not NewTextMagEvent is going to be allowed to continue running
; Exit without any further processing if either a menu or a menu bar is active
If (GlobalMenuMode != MENU_INACTIVE) then Return EndIf
; Exit without any further processing if the active control changed in dialog boxes since FocusChangedMagEvent will control MAGic tracking in dialog boxes when moving from control to control
If (DidControlChange () == 1) then Return EndIf
; Exit if the current window class is SysTreeView32, designed to speed up tracking in the Microsoft Outlook TreeView
If (cwClass == mWN_STV32) then Return EndIf
; Exit without any further processing if the window the new text was written to is not one of the windows that magConst.jsh specifies that
; NewTextMagEvent control tracking in
If !(StringContains (NewTextSetFocusWindows, TheClass) || StringContains (NewTextSetFocusWindows, "WT_" + IntToString (TheTypeCode))) then Return EndIf
;  The Windows 95 device manager is the only known example of a SysTreeViewClass in which FocusChangedMadEvent is not called when moving from
;  one item to another.  Therefore, return without further processing if in a window with a class of SysTreeView that is not in the Windows 95 device
;  manager
If (TheClass == mWN_STV) then
	If !(StringContains (GetWindowName (GetRealWindow (GetFocus ())), mWN_SysProperties)) then Return EndIf
Else EndIf
;  Exit without further processing if in a Word Perfect Edit window
If (StringContains (cwClass, mWN_WP)) then Return EndIf
;  Exit without further processing if in a combo box in a Microsoft Office dialog box and a caret is present
If (StringContains (TheClass, "bosa_sdm") && GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == TRUE) then Return EndIf
;  Initialize the remaining variables
Let TargetItem = 0
Let nteHandle = hwnd
Let nX = GetCursorCol ()
Let nY = GetCursorRow ()
;  Control tracking in the combo list box of Microsoft Office SDM dialogs
If (StringContains (TheClass, mWC_BosaSDM) && GetItemRect (nX, nY, nL, nR, nT, nB, IT_CARET) == FALSE) then
	GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
	MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
	Return
; Control MAGic tracking in combo list boxes, specifically the combo list box in Windows Explorer
ElIf (TheClass == mWN_ComboLBox) then
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		GetFocusRect (hwnd, nL, nR, nT, nB)
		MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
		Return
	EndIf
	Return
;  Control MAGic tracking in Combo Boxes.  FocusPointMovedMagEvent is capable of controlling the tracking in Combo Boxes except when pressing
;  enter to make a selection or pressing escape to cancel.  In these circumstances, control the tracking in NewTextMagEvent by calling TrackDialogBoxes.
ElIf (cwClass == mWN_ComboBox || cwTypeCode == WT_COMBOBOX) then
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		TrackDialogBoxes (nX, nY, 0, 0, 0, 0, 0, cwTypeCode, cwClass, GetAppMainWindow (GetCurrentWindow ()))
		Return
	EndIf
	Return
; Control MAGic tracking in the Windows 95 Device Manager
ElIf (TheClass == mWN_STV ) then
	GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_FIELD)
	MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
	Return
; Control MAGic tracking in Extended List Boxes
ElIf (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX) then
	GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_BOUNDINGRECT)
	MagSetFocusToRect (nL - 5, nR + 5, nT - 5, nB + 5, MTO_CARET)
	Return
;  Control MAGic tracking in Microsoft Outlook list view or any other window of class SUPERGRID
ElIf (cwClass == "SUPERGRID") then
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		GetLineRect (0, 0, nL, nR, nT, nB)
		MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_CARET)
		Return
	EndIf
; Control MAGic tracking in List Boxes
ElIf (TheClass == mWN_ListBox) then
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		Let bSuccess = FALSE
		Let bSuccess = GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_LINE)
		If (!bSuccess) then Let bSuccess = GetItemRect (GetCursorCol (), GetCursorRow (), nL, nR, nT, nB, IT_CHUNK)  EndIf
		Let nR = GetWindowRight (hwnd)
		MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
		Return
	EndIf
Else
; Control magic tracking in any other window in which NewTextMagEvent is allowed to function
	If (nAttributes & ATTRIB_HIGHLIGHT) then
		GetItemRect (0, 0, nL, nR, nT, nB, IT_CHUNK)
		MagSetFocusToRect (nL - 5, nR + 5, nT - 2, nB + 2, MTO_DIALOG)
		Return
	EndIf
EndIf
EndFunction

Void Function MenuModeMagEvent (handle WinHandle, int mode)
;  This function is designed to handle MAGic specific processing that must take place when
;  the state of a menu or menu bar changes.  The processing is designed to ensure that the
;  MAGic focus is on the item of primary interest.  How the area of primary interest is defined
;  depends largely upon the current menu mode.  There are three menu modes as defined in
;  HJCONST.JSH.  They are:  MENU_INACTIVE, MENUBAR_ACTIVE, and MENU_ACTIVE.  This
;  event is called with two parameters, the Handle of the menu and the mode of the menu.
Var Handle AppWindow,  Int nX,  Int nY, Int nLeftApp, Int nTopApp,  Int bSuccess, String cwClass,
	Int nL, Int nR, Int nT, Int nB
If (!MagGetState ()) then Return EndIf
if (GetWindowSubTypeCode(WinHandle) == WT_STARTMENU) then Return EndIf
Let MagMenuMode = mode
Let AppWindow = GetAppMainWindow (GetFocus ())
Let cwClass = GetWindowClass (GetCurrentWindow ())
Let nLeftApp = GetWindowLeft (AppWindow)
Let nTopApp = GetWindowTop (AppWindow)
Let nX = GetCursorCol ()
Let nY = GetCursorRow ()
If (MagMenuMode == MENU_INACTIVE) then Return 0 EndIf
; Control MAGic Tracking in Menu Bars
If (MagMenuMode == MENUBAR_ACTIVE) then
 ; Prevent jumpiness when using the mouse to activate one of the combo boxes in the
 ; Microsoft Office tool bars.  When the combo box is the active item (it contains a
 ; cursor) it has a window class of Edit.  In order to prevent focus from jumping to the
 ; top left corner of the screen (the location of the application context menu, handle
 ; the case of windows with class Edit in the menu bars here
	If (cwClass == mWC_Edit && GetWindowClass (GetParent (GetCurrentWindow ())) == mWN_OfficeBar) then
		Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
		If (!bSuccess) then  Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT) EndIf
		MagSetFocusToRect (nL - 2, nR + 2, nT - 2, nB + 2, MTO_MENUS)
		Return 1
;  This block of code is used to set the MAGic focus on toolbar icons
;  in Microsoft Office when navigated using the keyboard.  It is necessary because all
;  of the functions that return a rectangle fail to return a rectangle when the
;  Applcation Control Menu is selected.
; If the currently selected item is a icon on a Microsoft Office toolbar, set the MAGic focus to the bounding rectangle.
	ElIf (cwClass == mWN_OfficeBar) then
		GetItemRect (nX, nY, nL, nR, nT, nB, IT_BOUNDINGRECT)
		If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
		If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
		MagSetFocusToRect (nL, nR, nT, nB + 3, MTO_MENUS)
		Return 1
	Else
; This block of code is generic to all menu bars
		Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD)
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_WORD) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
		If (bSuccess) then
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			MagSetFocusToRect (nL, nR, nT, nB + 3, MTO_MENUS)
			Return 1
		Else
; Otherwise, set the MAGic focus to the top left corner of the main application window. (the location of the application
; control menu.
			Let nL = nLeftApp
			Let nT = nTopApp
			Let nR = nLeftApp + 25
			Let nB = nTopApp + 25
			MagSetFocusToRect (nL, nR, nT, nB, MTO_MENUS)
			Return 1
		EndIf
	EndIf
EndIf
If (MagMenuMode == MENU_ACTIVE) then
	Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB)
	If (!bSuccess) then Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB) EndIf
	If (bSuccess) then
		If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
		If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
		MagSetFocusToRect (nL, nR, nT, nB + 3, MTO_MENUS)
		Return 1
	Else
		Let bSuccess = GetLineRect (nX, nY, nL, nR, nT, nB)
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_HIGHLIGHT) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_CHUNK) EndIf
		If (!bSuccess) then Let bSuccess = GetItemRect (nX, nY, nL, nR, nT, nB, IT_FIELD) EndIf
		If (!bSuccess) then Return 0 Else
			If (nT <= 3) Then Let nT = 0 Else Let nT = nT - 3 EndIf
			If (nL <= 3) Then Let nL = 0 Else Let nL = nL - 3 EndIf
			Let nR = GetWindowLeft (GetCurrentWindow ())
			MagSetFocusToRect (nL, nR, nT, nB + 3, MTO_MENUS)
			Return 1
		EndIf
	EndIf
EndIf
EndFunction
